/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler.graph;

import java.util.HashSet;
import jjtraveler.Event;
import jjtraveler.Fail;
import jjtraveler.FailAtNodes;
import jjtraveler.Identity;
import jjtraveler.Logger;
import jjtraveler.Node;
import jjtraveler.VisitFailure;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;
import jjtraveler.graph.ASTToGraph;
import jjtraveler.graph.EdgesGraph;
import jjtraveler.graph.MkEdgeFromParent;
import jjtraveler.graph.MkEdgesToKids;
import jjtraveler.graph.ToGraph;

public class ToGraphTest
extends VisitorTestCase {
    public ToGraphTest(String test) {
        super(test);
    }

    public void testASTToGraph() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        ASTToGraph v = new ASTToGraph(g);
        v.visit(this.n0);
        EdgesGraph expected = new EdgesGraph();
        expected.addEdge(this.n0, this.n1);
        expected.addEdge(this.n0, this.n2);
        expected.addEdge(this.n1, this.n11);
        expected.addEdge(this.n1, this.n12);
        ToGraphTest.assertEquals((Object)expected, (Object)g);
    }

    public void testToGraphIdentity() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        ToGraph v = new ToGraph(g, (Visitor)new Identity());
        v.visit(this.n0);
        EdgesGraph expected = new EdgesGraph();
        expected.addEdge(this.n1, this.n11);
        expected.addEdge(this.n1, this.n12);
        expected.addEdge(this.n0, this.n1);
        expected.addEdge(this.n0, this.n2);
        ToGraphTest.assertEquals((Object)expected, (Object)g);
    }

    public void testToGraphFail() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        ToGraph v = new ToGraph(g, (Visitor)new Fail());
        v.visit(this.n0);
        EdgesGraph expected = new EdgesGraph();
        ToGraphTest.assertEquals((Object)expected, (Object)g);
    }

    public void testToGraphNoInternals() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        FailAtNodes select = new FailAtNodes(this.n1, this.n2);
        ToGraph v = new ToGraph(g, (Visitor)select);
        v.visit(this.n0);
        EdgesGraph expected = new EdgesGraph();
        expected.addEdge(this.n0, this.n11);
        expected.addEdge(this.n0, this.n12);
        ToGraphTest.assertEquals((Object)expected, (Object)g);
    }

    public void testToGraphNoRoot() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        FailAtNodes select = new FailAtNodes(this.n0, this.n0);
        ToGraph v = new ToGraph(g, (Visitor)this.logVisitor(select));
        v.visit(this.n0);
        Logger expectedLogger = new Logger();
        expectedLogger.log(new Event(select, this.n0));
        expectedLogger.log(new Event(select, this.n1));
        expectedLogger.log(new Event(select, this.n11));
        expectedLogger.log(new Event(select, this.n11));
        expectedLogger.log(new Event(select, this.n12));
        expectedLogger.log(new Event(select, this.n12));
        expectedLogger.log(new Event(select, this.n2));
        EdgesGraph expected = new EdgesGraph();
        expected.addEdge(this.n1, this.n11);
        expected.addEdge(this.n1, this.n12);
        ToGraphTest.assertEquals((Object)expected, (Object)g);
        ToGraphTest.assertEquals((Object)expectedLogger, (Object)this.logger);
    }

    public void testToGraphNoLeaves() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        HashSet<Node> leaves = new HashSet<Node>();
        leaves.add(this.n11);
        leaves.add(this.n12);
        leaves.add(this.n2);
        FailAtNodes select = new FailAtNodes(leaves);
        ToGraph v = new ToGraph(g, (Visitor)this.logVisitor(select));
        v.visit(this.n0);
        Logger expectedLogger = new Logger();
        expectedLogger.log(new Event(select, this.n0));
        expectedLogger.log(new Event(select, this.n1));
        expectedLogger.log(new Event(select, this.n1));
        expectedLogger.log(new Event(select, this.n11));
        expectedLogger.log(new Event(select, this.n12));
        expectedLogger.log(new Event(select, this.n2));
        EdgesGraph expected = new EdgesGraph();
        expected.addEdge(this.n0, this.n1);
        ToGraphTest.assertEquals((Object)expected, (Object)g);
        ToGraphTest.assertEquals((Object)expectedLogger, (Object)this.logger);
    }

    public void testMkEdgeFromParent() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        MkEdgeFromParent v = new MkEdgeFromParent(this.n0, g);
        v.visit(this.n1);
        EdgesGraph expectedGraph = new EdgesGraph();
        expectedGraph.addEdge(this.n0, this.n1);
        ToGraphTest.assertEquals((Object)expectedGraph, (Object)g);
    }

    public void testMkEdgesToKids() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        MkEdgesToKids v = new MkEdgesToKids(g);
        v.visit(this.n0);
        EdgesGraph expectedGraph = new EdgesGraph();
        expectedGraph.addEdge(this.n0, this.n1);
        expectedGraph.addEdge(this.n0, this.n2);
        ToGraphTest.assertEquals((Object)expectedGraph, (Object)g);
    }

    public void testMkEdgesToKidsSelective() throws VisitFailure {
        EdgesGraph g = new EdgesGraph();
        MkEdgesToKids v = new MkEdgesToKids(g, new FailAtNodes(this.n1, this.n2));
        v.visit(this.n0);
        EdgesGraph expectedGraph = new EdgesGraph();
        expectedGraph.addEdge(this.n0, this.n11);
        expectedGraph.addEdge(this.n0, this.n12);
        ToGraphTest.assertEquals((Object)expectedGraph, (Object)g);
    }
}

