/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import jjtraveler.Event;
import jjtraveler.Identity;
import jjtraveler.Logger;
import jjtraveler.SucceedAtNodes;
import jjtraveler.TopDownUntil;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;

public class TopDownUntilTest
extends VisitorTestCase {
    Visitor stopAt;
    Logger expected;

    public TopDownUntilTest(String test) {
        super(test);
    }

    public void setUp() {
        super.setUp();
        this.stopAt = new SucceedAtNodes(this.n1, this.n2);
        this.expected = new Logger();
    }

    public void testTopDownUntil() throws VisitFailure {
        this.expected.log(new Event(this.stopAt, this.n0));
        this.expected.log(new Event(this.stopAt, this.n1));
        this.expected.log(new Event(this.stopAt, this.n2));
        Visitable nodeReturned = new TopDownUntil(this.logVisitor(this.stopAt)).visit(this.n0);
        TopDownUntilTest.assertEquals((Object)this.expected, (Object)this.logger);
        TopDownUntilTest.assertEquals((Object)this.n0, (Object)nodeReturned);
    }

    public void testTopDownAtBorder() throws VisitFailure {
        Identity borderAction = new Identity();
        this.expected.log(new Event(this.stopAt, this.n0));
        this.expected.log(new Event(this.stopAt, this.n1));
        this.expected.log(new Event(borderAction, this.n1));
        this.expected.log(new Event(this.stopAt, this.n2));
        this.expected.log(new Event(borderAction, this.n2));
        Visitable nodeReturned = new TopDownUntil(this.logVisitor(this.stopAt), this.logVisitor(borderAction)).visit(this.n0);
        TopDownUntilTest.assertEquals((Object)this.expected, (Object)this.logger);
        TopDownUntilTest.assertEquals((Object)this.n0, (Object)nodeReturned);
    }
}

