/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import jjtraveler.FailAtNodes;
import jjtraveler.Identity;
import jjtraveler.Logger;
import jjtraveler.SpineBottomUp;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;

public class SpineBottomUpTest
extends VisitorTestCase {
    public SpineBottomUpTest(String test) {
        super(test);
    }

    public void testSpineBottomUpAtInnerNode() throws VisitFailure {
        FailAtNodes stop = new FailAtNodes(this.n1);
        SpineBottomUp spineBottomUp = new SpineBottomUp(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n11, this.n1, this.n2, this.n0});
        Visitable nodeReturned = spineBottomUp.visit(this.n0);
        SpineBottomUpTest.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        SpineBottomUpTest.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineBottomUpAtLeaf() throws VisitFailure {
        FailAtNodes stop = new FailAtNodes(this.n11);
        SpineBottomUp spineBottomUp = new SpineBottomUp(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n11, this.n12, this.n1, this.n0});
        Visitable nodeReturned = spineBottomUp.visit(this.n0);
        SpineBottomUpTest.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        SpineBottomUpTest.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineBottomUpOnlySuccess() throws VisitFailure {
        Identity dontStop = new Identity();
        SpineBottomUp spineBottomUp = new SpineBottomUp(this.logVisitor(dontStop));
        Logger expected = new Logger((Visitor)dontStop, new Visitable[]{this.n11, this.n1, this.n0});
        Visitable nodeReturned = spineBottomUp.visit(this.n0);
        SpineBottomUpTest.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        SpineBottomUpTest.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineBottomUpFailAtTop() {
        FailAtNodes stop = new FailAtNodes(this.n0);
        SpineBottomUp spineBottomUp = new SpineBottomUp(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n11, this.n1, this.n0});
        Visitable nodeReturned = null;
        try {
            nodeReturned = spineBottomUp.visit(this.n0);
            SpineBottomUpTest.fail((String)"VisitFailure should have occured!");
        }
        catch (VisitFailure visitFailure) {
            SpineBottomUpTest.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
            SpineBottomUpTest.assertNull((String)"return value", (Object)nodeReturned);
        }
    }

    public void testSpineBottomUpFailAtInners() {
        FailAtNodes stop = new FailAtNodes(this.n1, this.n2);
        SpineBottomUp spineBottomUp = new SpineBottomUp(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n11, this.n1, this.n2});
        Visitable nodeReturned = null;
        try {
            nodeReturned = spineBottomUp.visit(this.n0);
            SpineBottomUpTest.fail((String)"VisitFailure should have occured!");
        }
        catch (VisitFailure visitFailure) {
            SpineBottomUpTest.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
            SpineBottomUpTest.assertNull((String)"return value", (Object)nodeReturned);
        }
    }
}

