/*
 * Decompiled with CFR 0.152.
 */
package aterm.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class BufferedOutputStreamWriter
extends Writer {
    private static final int DEFAULTBUFFERSIZE = 8192;
    private OutputStream stream;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private int limit = 0;
    private boolean failures = false;

    public BufferedOutputStreamWriter(OutputStream stream) {
        this(stream, 8192);
    }

    public BufferedOutputStreamWriter(OutputStream stream, int bufferSize) {
        this.stream = stream;
        this.buffer = new byte[bufferSize];
        this.limit = this.buffer.length;
    }

    public void write(char c) {
        this.buffer[this.bufferPos++] = (byte)c;
        if (this.bufferPos == this.limit) {
            this.flush();
        }
    }

    public void write(char[] cbuf, int offset, int length) {
        this.write(new String(cbuf, offset, length));
    }

    public void write(String s) {
        byte[] bytes = s.getBytes();
        int bytesLeft = bytes.length;
        int startPos = 0;
        while (bytesLeft > 0) {
            int freeSpace = this.limit - this.bufferPos;
            int bytesToWrite = bytesLeft;
            if (freeSpace < bytesToWrite) {
                bytesToWrite = freeSpace;
            }
            System.arraycopy(bytes, startPos, this.buffer, this.bufferPos, bytesToWrite);
            this.bufferPos += bytesToWrite;
            if (this.bufferPos == this.limit) {
                this.flush();
            }
            bytesLeft -= bytesToWrite;
            startPos += bytesToWrite;
        }
    }

    public void flush() {
        try {
            this.stream.write(this.buffer, 0, this.bufferPos);
            this.bufferPos = 0;
            this.stream.flush();
        }
        catch (IOException iOException) {
            this.failures = true;
        }
    }

    public void close() {
        try {
            this.flush();
            this.stream.close();
        }
        catch (IOException iOException) {
            this.failures = true;
        }
    }

    public boolean hasFailed() {
        return this.failures;
    }
}

