/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.Visitable;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import java.util.List;
import jjtraveler.VisitFailure;
import shared.HashFunctions;
import shared.SharedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATermPlaceholderImpl
extends ATermImpl
implements ATermPlaceholder {
    private ATerm type;

    protected ATermPlaceholderImpl(PureFactory factory) {
        super(factory);
    }

    protected ATermPlaceholderImpl(PureFactory factory, ATermList annos, ATerm type) {
        super(factory, annos);
        this.type = type;
        this.setHashCode(HashFunctions.doobs((Object[])new Object[]{annos, type}));
    }

    @Override
    public int getType() {
        return 5;
    }

    protected void init(int hashCode, ATermList annos, ATerm type) {
        super.init(hashCode, annos);
        this.type = type;
    }

    public SharedObject duplicate() {
        return this;
    }

    @Override
    public boolean equivalent(SharedObject obj) {
        if (super.equivalent(obj)) {
            ATermPlaceholder peer = (ATermPlaceholder)obj;
            return peer.getPlaceholder() == this.type;
        }
        return false;
    }

    @Override
    public boolean match(ATerm pattern, List<Object> list) {
        ATermAppl appl;
        AFun afun;
        ATerm t;
        if (pattern.getType() == 5 && (t = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)t).getAFun()).getName().equals("placeholder") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(t);
            return true;
        }
        return super.match(pattern, list);
    }

    @Override
    public ATerm make(List<Object> args) {
        ATermAppl appl = (ATermAppl)this.type;
        AFun fun = appl.getAFun();
        String name = fun.getName();
        if (!fun.isQuoted()) {
            if (fun.getArity() == 0) {
                if (name.equals("term")) {
                    ATerm t = (ATerm)args.get(0);
                    args.remove(0);
                    return t;
                }
                if (name.equals("list")) {
                    ATermList l = (ATermList)args.get(0);
                    args.remove(0);
                    return l;
                }
                if (name.equals("bool")) {
                    Boolean b = (Boolean)args.get(0);
                    args.remove(0);
                    return this.factory.makeAppl(this.factory.makeAFun(b.toString(), 0, false));
                }
                if (name.equals("int")) {
                    Integer i = (Integer)args.get(0);
                    args.remove(0);
                    return this.factory.makeInt(i);
                }
                if (name.equals("real")) {
                    Double d = (Double)args.get(0);
                    args.remove(0);
                    return this.factory.makeReal(d);
                }
                if (name.equals("placeholder")) {
                    ATerm t = (ATerm)args.get(0);
                    args.remove(0);
                    return this.factory.makePlaceholder(t);
                }
                if (name.equals("str")) {
                    String str = (String)args.get(0);
                    args.remove(0);
                    return this.factory.makeAppl(this.factory.makeAFun(str, 0, true));
                }
                if (name.equals("id")) {
                    String str = (String)args.get(0);
                    args.remove(0);
                    return this.factory.makeAppl(this.factory.makeAFun(str, 0, false));
                }
                if (name.equals("fun")) {
                    String str = (String)args.get(0);
                    args.remove(0);
                    return this.factory.makeAppl(this.factory.makeAFun(str, 0, false));
                }
            }
            if (name.equals("appl")) {
                ATermList oldargs = appl.getArguments();
                String newname = (String)args.get(0);
                args.remove(0);
                ATermList newargs = (ATermList)oldargs.make(args);
                AFun newfun = this.factory.makeAFun(newname, newargs.getLength(), false);
                return this.factory.makeApplList(newfun, newargs);
            }
        }
        throw new RuntimeException("illegal pattern: " + this);
    }

    @Override
    public ATerm getPlaceholder() {
        return this.type;
    }

    public ATerm setPlaceholder(ATerm newtype) {
        return this.getPureFactory().makePlaceholder(newtype, this.getAnnotations());
    }

    @Override
    public ATerm setAnnotations(ATermList annos) {
        return this.getPureFactory().makePlaceholder(this.type, annos);
    }

    @Override
    public Visitable accept(Visitor v) throws VisitFailure {
        return v.visitPlaceholder(this);
    }

    @Override
    public int getNrSubTerms() {
        return 1;
    }

    @Override
    public ATerm getSubTerm(int index) {
        return this.type;
    }

    @Override
    public ATerm setSubTerm(int index, ATerm t) {
        if (index == 1) {
            return this.setPlaceholder(t);
        }
        throw new RuntimeException("no " + index + "-th child!");
    }
}

