/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.Visitable;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import java.util.ArrayList;
import java.util.List;
import jjtraveler.VisitFailure;
import shared.SharedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATermListImpl
extends ATermImpl
implements ATermList {
    private ATerm first;
    private ATermList next;
    private int length;

    protected ATermListImpl(PureFactory factory) {
        super(factory);
    }

    protected ATermListImpl(PureFactory factory, ATermList annos, ATerm first, ATermList next) {
        super(factory, annos);
        this.first = first;
        this.next = next;
        this.length = first == null && next == null ? 0 : 1 + next.getLength();
        this.setHashCode(this.hashFunction());
    }

    @Override
    public int getType() {
        return 4;
    }

    protected void init(int hashCode, ATermList annos, ATerm first, ATermList next) {
        super.init(hashCode, annos);
        this.first = first;
        this.next = next;
        this.length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    protected void initHashCode(ATermList annos, ATerm first, ATermList next) {
        this.first = first;
        this.next = next;
        this.internSetAnnotations(annos);
        this.setHashCode(this.hashFunction());
        this.length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    public SharedObject duplicate() {
        return this;
    }

    @Override
    public boolean equivalent(SharedObject obj) {
        if (super.equivalent(obj)) {
            ATermList peer = (ATermList)obj;
            return peer.getFirst() == this.first && peer.getNext() == this.next;
        }
        return false;
    }

    @Override
    public ATermList insert(ATerm el) {
        ATermListImpl tail = !this.hasAnnotations() ? this : (ATermList)this.removeAnnotations();
        return this.getPureFactory().makeList(el, tail);
    }

    protected ATermList make(ATerm head, ATermList tail) {
        return this.make(head, tail, this.getPureFactory().makeList());
    }

    protected ATermList make(ATerm head, ATermList tail, ATermList annos) {
        return this.getPureFactory().makeList(head, tail, annos);
    }

    @Override
    public ATermList getEmpty() {
        return this.getPureFactory().makeList();
    }

    @Override
    public ATerm setAnnotations(ATermList annos) {
        return this.make(this.first, this.next, annos);
    }

    @Override
    protected boolean match(ATerm pattern, List<Object> list) {
        if (pattern.getType() == 4) {
            ATermAppl appl;
            ATerm ph_type;
            ATermList l = (ATermList)pattern;
            if (l.isEmpty()) {
                return this.isEmpty();
            }
            if (l.getFirst().getType() == 5 && (ph_type = ((ATermPlaceholder)l.getFirst()).getPlaceholder()).getType() == 1 && (appl = (ATermAppl)ph_type).getName().equals("list") && appl.getArguments().isEmpty()) {
                list.add(this);
                return true;
            }
            if (!this.isEmpty()) {
                List<Object> submatches = this.first.match(l.getFirst());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                submatches = this.next.match(l.getNext());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                return true;
            }
            return l.isEmpty();
        }
        return super.match(pattern, list);
    }

    @Override
    public ATerm make(List<Object> args) {
        if (this.first == null) {
            return this;
        }
        ATerm head = this.first.make(args);
        ATermList tail = (ATermList)this.next.make(args);
        if (this.isListPlaceHolder(this.first)) {
            return head;
        }
        return tail.insert(head);
    }

    private boolean isListPlaceHolder(ATerm pattern) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        return pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("list") && afun.getArity() == 0 && !afun.isQuoted();
    }

    @Override
    public boolean isEmpty() {
        return this.first == null && this.next == null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ATerm getFirst() {
        return this.first;
    }

    @Override
    public ATermList getNext() {
        return this.next;
    }

    @Override
    public ATerm getLast() {
        ATermList cur = this;
        while (!cur.getNext().isEmpty()) {
            cur = cur.getNext();
        }
        return cur.getFirst();
    }

    @Override
    public int indexOf(ATerm el, int start) {
        if (start < 0) {
            start += this.length + 1;
        }
        if (start > this.length) {
            throw new IllegalArgumentException("start (" + start + ") > length of list (" + this.length + ")");
        }
        ATermList cur = this;
        int i = 0;
        while (i < start) {
            cur = cur.getNext();
            ++i;
        }
        while (!cur.isEmpty() && cur.getFirst() != el) {
            cur = cur.getNext();
            ++i;
        }
        return cur.isEmpty() ? -1 : i;
    }

    @Override
    public int lastIndexOf(ATerm el, int start) {
        int result;
        if (start < 0) {
            start += this.length + 1;
        }
        if (start > this.length) {
            throw new IllegalArgumentException("start (" + start + ") > length of list (" + this.length + ")");
        }
        if (start > 0 && (result = this.next.lastIndexOf(el, start - 1)) >= 0) {
            return result + 1;
        }
        if (this.first == el) {
            return 0;
        }
        return -1;
    }

    @Override
    public ATermList concat(ATermList rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (this.next.isEmpty()) {
            return rhs.insert(this.first);
        }
        return this.next.concat(rhs).insert(this.first);
    }

    @Override
    public ATermList append(ATerm el) {
        return this.concat(this.getEmpty().insert(el));
    }

    @Override
    public ATerm elementAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("illegal list index: " + index);
        }
        ATermList cur = this;
        int i = 0;
        while (i < index) {
            cur = cur.getNext();
            ++i;
        }
        return cur.getFirst();
    }

    @Override
    public ATermList remove(ATerm el) {
        if (this.first == el) {
            return this.next;
        }
        ATermList result = this.next.remove(el);
        if (result == this.next) {
            return this;
        }
        return result.insert(this.first);
    }

    @Override
    public ATermList removeElementAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IllegalArgumentException("illegal list index: " + index);
        }
        if (index == 0) {
            return this.next;
        }
        return this.next.removeElementAt(index - 1).insert(this.first);
    }

    @Override
    public ATermList removeAll(ATerm el) {
        if (this.first == el) {
            return this.next.removeAll(el);
        }
        ATermList result = this.next.removeAll(el);
        if (result == this.next) {
            return this;
        }
        return result.insert(this.first);
    }

    @Override
    public ATermList insertAt(ATerm el, int i) {
        if (i < 0 || i > this.length) {
            throw new IllegalArgumentException("illegal list index: " + i);
        }
        if (i == 0) {
            return this.insert(el);
        }
        return this.next.insertAt(el, i - 1).insert(this.first);
    }

    @Override
    public ATermList getPrefix() {
        if (this.isEmpty()) {
            return this;
        }
        ATermList cur = this;
        ArrayList<ATerm> elems = new ArrayList<ATerm>();
        while (true) {
            if (cur.getNext().isEmpty()) {
                cur = this.getPureFactory().getEmpty();
                int i = elems.size() - 1;
                while (i >= 0) {
                    cur = cur.insert((ATerm)elems.get(i));
                    --i;
                }
                return cur;
            }
            elems.add(cur.getFirst());
            cur = cur.getNext();
        }
    }

    @Override
    public ATermList getSlice(int start, int end) {
        int size = end - start;
        ATermList list = this;
        int i = 0;
        while (i < start) {
            list = list.getNext();
            ++i;
        }
        ArrayList<ATerm> buffer = new ArrayList<ATerm>(size);
        i = 0;
        while (i < size) {
            buffer.add(list.getFirst());
            list = list.getNext();
            ++i;
        }
        ATermList result = this.getPureFactory().getEmpty();
        --i;
        while (i >= 0) {
            result = result.insert((ATerm)buffer.get(i));
            --i;
        }
        return result;
    }

    @Override
    public ATermList replace(ATerm el, int i) {
        if (i < 0 || i > this.length) {
            throw new IllegalArgumentException("illegal list index: " + i);
        }
        ArrayList<ATerm> buffer = new ArrayList<ATerm>(i);
        ATermList cur = this;
        int lcv = 0;
        while (lcv < i) {
            buffer.add(cur.getFirst());
            cur = cur.getNext();
            ++lcv;
        }
        cur = cur.getNext();
        cur = cur.insert(el);
        --lcv;
        while (lcv >= 0) {
            cur = cur.insert((ATerm)buffer.get(lcv));
            --lcv;
        }
        return cur;
    }

    @Override
    public ATermList reverse() {
        ATermList cur = this;
        ATermList reverse = this.getEmpty();
        while (!cur.isEmpty()) {
            reverse = reverse.insert(cur.getFirst());
            cur = cur.getNext();
        }
        return reverse;
    }

    @Override
    public ATerm dictGet(ATerm key) {
        if (this.isEmpty()) {
            return null;
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            return pair.getNext().getFirst();
        }
        return this.next.dictGet(key);
    }

    @Override
    public ATermList dictPut(ATerm key, ATerm value) {
        if (this.isEmpty()) {
            ATermList pair = this.getEmpty().insert(value).insert(key);
            return this.getEmpty().insert(pair);
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            pair = this.getEmpty().insert(value).insert(pair);
            return this.next.insert(pair);
        }
        return (ATermList)this.next.dictPut(key, value).insert(this.first).setAnnotations(this.getAnnotations());
    }

    @Override
    public ATermList dictRemove(ATerm key) {
        if (this.isEmpty()) {
            return this;
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            return this.next;
        }
        return (ATermList)this.next.dictRemove(key).insert(this.first).setAnnotations(this.getAnnotations());
    }

    @Override
    public Visitable accept(Visitor v) throws VisitFailure {
        return v.visitList(this);
    }

    @Override
    public int getNrSubTerms() {
        return this.length;
    }

    @Override
    public ATerm getSubTerm(int index) {
        return this.elementAt(index);
    }

    @Override
    public ATerm setSubTerm(int index, ATerm t) {
        return this.replace(t, index);
    }

    protected int findEmptyHashCode() {
        int magic = 0;
        int x = Integer.MIN_VALUE;
        while (x < Integer.MAX_VALUE) {
            int a = -1640531527;
            int b = -1640531527;
            int c = 3;
            a += x << 16;
            a -= b;
            a -= c;
            b -= c;
            b -= (a ^= c >> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >> 13);
            b -= c;
            b -= (a ^= c >> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >> 5);
            b -= c;
            b -= (a ^= c >> 3);
            c -= a;
            c -= (b ^= a << 10);
            if ((c ^= b >> 15) == x) {
                System.out.println("magic x = " + x);
                magic = x;
            }
            if (x % 100000000 == 0) {
                System.out.println("x = " + x);
            }
            ++x;
        }
        return magic;
    }

    private int hashFunction() {
        int a = -1640531527;
        int b = -1640531527;
        int c = 3;
        a += this.getAnnotations().hashCode() << 16;
        if (this.next != null && this.first != null) {
            a += this.next.hashCode() << 8;
            a += this.first.hashCode();
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

